<?php
/**
 * Plugin Name: Srizon AI Image
 * Plugin URI: https://www.srizon.com/srizon-ai-image
 * Description: Generate AI images using Google Gemini directly in WordPress editor and media library.
 * Version: 1.0.3
 * Author: Srizon
 * Author URI: https://www.srizon.com
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: srizon-ai-image
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 *
 * @package Srizon_AI_Image
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Plugin version - dynamically read from plugin header.
 */
if ( ! function_exists( 'get_plugin_data' ) ) {
    require_once ABSPATH . 'wp-admin/includes/plugin.php';
}
$srizon_ai_image_plugin_data = get_plugin_data( __FILE__, false, false );
define( 'SRIZON_AI_IMAGE_VERSION', $srizon_ai_image_plugin_data['Version'] );

/**
 * Plugin base path.
 */
define( 'SRIZON_AI_IMAGE_PATH', plugin_dir_path( __FILE__ ) );

/**
 * Plugin base URL.
 */
define( 'SRIZON_AI_IMAGE_URL', plugin_dir_url( __FILE__ ) );

/**
 * Code that runs during plugin activation.
 */
function srizon_ai_image_activate() {
    require_once SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image-activator.php';
    Srizon_AI_Image_Activator::activate();
}

/**
 * Code that runs during plugin deactivation.
 */
function srizon_ai_image_deactivate() {
    require_once SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image-deactivator.php';
    Srizon_AI_Image_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'srizon_ai_image_activate' );
register_deactivation_hook( __FILE__, 'srizon_ai_image_deactivate' );

/**
 * The core plugin class.
 */
require SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image.php';

/**
 * Begins execution of the plugin.
 */
function srizon_ai_image_run() {
    $plugin = new Srizon_AI_Image();
    $plugin->run();
}

srizon_ai_image_run();
